\name{phtnnet.Hess}
\alias{phtnnet.Hess}
\title{
Evaluates Hessian for a Time-varying Neural Net
}
\description{
Evaluates the Hessian (matrix of second derivatives) of the specified
neural network. Normally called via argument \code{dohess=T} to \code{phtnnet}.  
Calling it direct is not recommended.
}
\usage{
phtnnet.Hess(net, x, status)
}
\arguments{
\item{net}{
object of class \code{phtnnet} as returned by \code{phtnnet}.
}
\item{x}{
training data.  Must be in the form of a \code{model.matrix} output.  A time
zone column will be added by the code, but if one is present this will
be used instead.
}
\item{status}{
status of training data.  
May include time if data is not sorted, as for \code{phtnnet}
}}
\value{
square symmetric matrix of the Hessian evaluated at the weights stored 
in the net.
}
\seealso{
\code{\link{phtnnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1    


            
phtfit <-  phtnnet(Surv(time,status)   ~ ., data=mylung[,-1], 
		decay = 0.01, size = 2, skip=TRUE, trace = TRUE,
		maxit=1000, breakpts=c(0,100,200,300,10000))
eigen(phtnnet.Hess(phtfit,na.omit(mylung[,-1])[,3:9],
	na.omit(mylung[,-1])[,1:2]), TRUE)$values
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
