\name{phnnet}
\alias{phnnet}
\alias{phnnet.formula}
\alias{phnnet.default}
\alias{print.phnnet}
\alias{print.summary.phnnet}
\alias{summary.phnnet}
\alias{eval.pnn}
\title{
Fit Proportional Hazard Survival Models
}
\description{
Fits a proportional hazards model using output
of a neural net
}
\usage{
phnnet.formula(formula, data=NULL, \dots,
               subset, na.action=na.fail, contrasts=NULL)
phnnet.default(x, status, size, Wts, mask,  skip=FALSE, rang=0.7, 
               decay=0, bias.decay=1, MaxNWts=1000, maxit=100, 
               trace=TRUE, dohaz=FALSE, dohess=FALSE)
}
\arguments{
\item{formula}{
A formula of the form \code{ Response ~ x1 + x2 + \dots}.  See Details below.
}
\item{x}{
matrix or data frame of \code{x} values for examples.
}
\item{status}{
matrix containing Survival time and censoring indicator, or vector
containing censoring indicator (see Details below).
}
\item{size}{
number of units in the hidden layer. Can be zero if there are skip-layer units.
}
\item{data}{
Data frame from which variables specified in  \code{formula} are
preferentially to be taken.
}
\item{subset}{
An index vector specifying the cases to be used in the training
sample.  (NOTE: If given, this argument must be named.)
}
\item{na.action}{
A function to specify the action to be taken if \code{NA}s are found.
The default action is for the procedure to fail.  An alternative is
na.omit, which leads to rejection of cases with missing values on
any required variable.  (NOTE: If given, this argument must be named.)
}
\item{contrasts}{
a list of contrasts to be used for some or all  of
the  factors  appearing as variables in the model formula.
}
\item{Wts}{
initial parameter vector. If missing chosen at random.
}
\item{mask}{
vector used to indicate which weights should be varied.
}
\item{skip}{
switch to add skip-layer connections from input to output.
}
\item{rang}{
Initial random weights on [-\code{rang}, \code{rang}].  Value about 0.5 unless the 
inputs are large, in which case it should be chosen so that 
\code{rang * max(|x|)} is about 1.
}
\item{decay}{
parameter for weight decay.  Default 0.  May be a single value to be used for 
all weights, or a vector 
the same length as the weights vector.
}
\item{bias.decay}{
factor by which to divide the weight decay for weights from the bias unit. 
(Easy way to use two values of weight decay only).
}
\item{MaxNWts}{
The maximum allowable number of weights.  There is no intrinsic limit
in the code, but increasing \code{MaxNWts} will probably allow fits that are
very slow and time-consuming (and perhaps uninterruptable under
Windows).
}
\item{maxit}{
maximum number of iterations. Default 100.
}
\item{trace}{
switch for tracing optimization. Default \code{True}.
}
\item{dohaz}{
If true, the cumulative hazard function estimated at the best set of weights
is returned as component \code{haz}.
}
\item{dohess}{
If true, the Hessian of the measure of fit at the best set of weights
found is returned as component \code{hess}.}
\item{\dots}{further arguments passed to the default method.}
}
\value{
Object of class \code{"phnnet.formula"} or \code{"phnnet"} with components

\item{wts}{
the best set of weights found
}
\item{value}{
value of fitting criterion plus weight decay term.
}
\item{fitted.values}{
the fitted values for the training data.
}}
\details{
The code depends on the data being sorted in decreasing order of
survival time.  If your data is not sorted in this way, the \code{Response}
(or \code{status}) must be \code{Surv(Time, Event)} or equivalent. If the data are
already sorted \code{Response} or \code{status} need only be a censoring indicator
(1 for event, 0 for censored).
A neural network is used to fit a function of the covariates in a
proportional hazards model.  The code is based on \code{nnet}, but with
significant changes since the partial likelihood is not a sum over
examples. Note that case weights are not currently available.
There is no bias on the output layer: the total number of weights
includes this one, but it is not used.
A quasi-Newton optimizer is used, written in \code{C}.
}
\references{
Cox, D.R. (1972) Regression models and life-tables (with discussion). JRSSB, 
\bold{26}, 211--252.
D. Faraggi & R. Simon (1995) "A neural network model for survival data."
Statistics in Medicine \bold{14}, 73--82.
R. M. Ripley (2004) "\code{survnnet}: Neural network survival models:
Version 1.1." 
Part of documentation of this package.
}
\seealso{
\code{\link{predict.phnnet}}, \code{\link{phnnet.Hess}}, \code{\link{phtnnet}}, \code{\link{survnnet}}, \code{\link[nnet]{nnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1                


phfit <-  phnnet(Surv(time,status)  ~ ., data=mylung[,-1], decay = 0.01,
size = 2, skip=TRUE, trace = TRUE, maxit = 1000,  bias.decay=25)
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
