\name{phnnet.Hess}
\alias{phnnet.Hess}
\title{
Evaluates Hessian for a Proportional Hazards Net
}
\description{
Evaluates the Hessian (matrix of second derivatives) of the specified
neural network. Normally called via argument \code{dohess=T} to \code{phnnet}.
}
\usage{
phnnet.Hess(net, x, status)
}
\arguments{
\item{net}{
object of class \code{phnnet} as returned by \code{phnnet}.
}
\item{x}{
training data.  Must be in the form of a \code{model.matrix} output.
}
\item{status}{
status of training data
}
}
\value{
square symmetric matrix of the Hessian evaluated at the weights stored 
in the net.
}
\seealso{
\code{\link{phnnet}}, \code{\link{predict.phnnet}}
}
\examples{
library(survival)
data(lung)
mylung <- apply(lung[,4:10],2,function(x)(x-min(x,na.rm=TRUE))/
		(range(x,na.rm=TRUE)[2]-range(x,na.rm=TRUE)[1])) 
mylung <- cbind(lung[,1:3],mylung) 
mylung$status <- mylung$status-1                


phfit <-  phnnet(Surv(time,status)  ~ ., data=mylung[,-1], decay = 0.01,
size = 2, skip=TRUE, trace = TRUE, maxit = 1000,  bias.decay=25)


eigen(phnnet.Hess(phfit,na.omit(mylung[,-1])[,3:9],
	na.omit(mylung[,-1])[,1:2]), TRUE)$values 
}
\keyword{neural}
% Converted by Sd2Rd version 1.21.
