##################################################################
# R script for assignment on multi-group options & meta-analysis #
##################################################################

# load RSiena commands:
library(RSiena)

# set working directory to where the data are:
setwd("<adjust to where the data are>")
list.files()

# Please also copy the data from classroom 12b into this directory.
# They can be found on the SIENA website.
#
# ---------------- READING & MANIPULTING THE DATA -------------
# 
# read the data sets for the assignment:
klas03efriend1 <- as.matrix(read.table("klas03e-friends-waveA.dat"))
klas03efriend2 <- as.matrix(read.table("klas03e-friends-waveB.dat"))
klas03eprimary.net <- as.matrix(read.table("klas03e-primary.dat"))
klas03edemographics <- as.matrix(read.table("klas03e-demographics.dat"))
klas12bfriend1 <- as.matrix(read.table("klas12b-net-1.dat"))
klas12bfriend2 <- as.matrix(read.table("klas12b-net-2.dat"))
klas12bprimary.net <- as.matrix(read.table("klas12b-primary.dat"))
klas12bdemographics <- as.matrix(read.table("klas12b-demographics.dat"))
klas12pfriend1 <- as.matrix(read.table("klas12p-friends-waveA.dat"))
klas12pfriend2 <- as.matrix(read.table("klas12p-friends-waveB.dat"))
klas12pprimary.net <- as.matrix(read.table("klas12p-primary.dat"))
klas12pdemographics <- as.matrix(read.table("klas12p-demographics.dat"))

# identify missing values (see 'klasdata-readme.txt'):
klas03efriend1[klas03efriend1==9] <- NA
klas03efriend2[klas03efriend2==9] <- NA
klas03eprimary.net[klas03eprimary.net==9] <- NA
klas03edemographics[klas03edemographics==0] <- NA
klas12bfriend1[klas12bfriend1==9] <- NA
klas12bfriend2[klas12bfriend2==9] <- NA
klas12bprimary.net[klas12bprimary.net==9] <- NA
klas12bdemographics[klas12bdemographics==0] <- NA
klas12pfriend1[klas12pfriend1==9] <- NA
klas12pfriend2[klas12pfriend2==9] <- NA
klas12pprimary.net[klas12pprimary.net==9] <- NA
klas12pdemographics[klas12pdemographics==0] <- NA

# find out number of actors in data sets:
klas03enumberActors <- dim(klas03edemographics)[1]
klas12bnumberActors <- dim(klas12bdemographics)[1]
klas12pnumberActors <- dim(klas12pdemographics)[1]

# identify dependent variable for the analysis:
klas03efriends <- sienaNet(array(c(klas03efriend1,klas03efriend2),
  dim=c(klas03enumberActors,klas03enumberActors,2)))
klas12bfriends <- sienaNet(array(c(klas12bfriend1,klas12bfriend2),
  dim=c(klas12bnumberActors,klas12bnumberActors,2)))
klas12pfriends <- sienaNet(array(c(klas12pfriend1,klas12pfriend2),
  dim=c(klas12pnumberActors,klas12pnumberActors,2)))

# identify covariates for the analysis:
klas03esex.M <- coCovar(klas03edemographics[,1])
klas03eprimary <- coDyadCovar(klas03eprimary.net)
klas12bsex.M <- coCovar(klas12bdemographics[,1])
klas12bprimary <- coDyadCovar(klas12bprimary.net)
klas12psex.M <- coCovar(klas12pdemographics[,1])
klas12pprimary <- coDyadCovar(klas12pprimary.net)

# combine data for the analysis (& make sure variable names
# are identical in the different project data objects!):
klas03edata <- sienaDataCreate(friends=klas03efriends,sexM=klas03esex.M,primary=klas03eprimary)
klas12bdata <- sienaDataCreate(friends=klas12bfriends,sexM=klas12bsex.M,primary=klas12bprimary)
klas12pdata <- sienaDataCreate(friends=klas12pfriends,sexM=klas12psex.M,primary=klas12pprimary)

# ---------------- STARTING MULTI-GROUP ANALYSIS -----------

# and join into multi-group project:
groupdata <- sienaGroupCreate(list(klas03edata,klas12bdata,klas12pdata))

# get effects object:
groupEffects <- getEffects(groupdata)

# etc. (the rest follows the same pattern as 'normal' analyses).
# More specifically:

groupEffects <- includeEffects(groupEffects,transTrip,cycle3)
groupEffects <- includeEffects(groupEffects,X,interaction1="primary")
groupEffects <- includeEffects(groupEffects,egoX,altX,sameX,interaction1="sexM")

# define model object for this fixed effects analysis:
groupModel <- sienaModelCreate(useStdInits=FALSE, projname='group')

# finally estimate the model (note that by "batch=FALSE", the graphical user
# interface is switched off to speed up calculations): 
groupResults <- siena07(groupModel, data=groupdata, effects=groupEffects, batch=TRUE, verbose=FALSE)

# Results for this analysis are reported in file "group.out" or can be obtained by 
# inspecting the results object.

# NOW it may be interesting to find out to what degree classes differ on
# the model dimensions. The following analysis shows how to do this.
#
# For finding such differences between classrooms, first create dummy variables:
klas03edummy03e <- rep(1,klas03enumberActors)
klas12bdummy03e <- rep(0,klas12bnumberActors)
klas12pdummy03e <- rep(0,klas12pnumberActors)
klas03edummy12b <- rep(0,klas03enumberActors)
klas12bdummy12b <- rep(1,klas12bnumberActors)
klas12pdummy12b <- rep(0,klas12pnumberActors)

# transform these into Siena covariates:
klas03edummy03eSiena <- coCovar(klas03edummy03e)
klas12bdummy03eSiena <- coCovar(klas12bdummy03e)
klas12pdummy03eSiena <- coCovar(klas12pdummy03e)
klas03edummy12bSiena <- coCovar(klas03edummy12b)
klas12bdummy12bSiena <- coCovar(klas12bdummy12b)
klas12pdummy12bSiena <- coCovar(klas12pdummy12b)

# combine data for the analysis (& make sure variable names
# are identical in the different project data objects!):
klas03edata <- sienaDataCreate(friends=klas03efriends,sexM=klas03esex.M,primary=klas03eprimary,dummy03e=klas03edummy03eSiena,dummy12b=klas03edummy12bSiena)
klas12bdata <- sienaDataCreate(friends=klas12bfriends,sexM=klas12bsex.M,primary=klas12bprimary,dummy03e=klas12bdummy03eSiena,dummy12b=klas12bdummy12bSiena)
klas12pdata <- sienaDataCreate(friends=klas12pfriends,sexM=klas12psex.M,primary=klas12pprimary,dummy03e=klas12pdummy03eSiena,dummy12b=klas12pdummy12bSiena)

# and join into multi-group project:
groupdata <- sienaGroupCreate(list(klas03edata,klas12bdata,klas12pdata))

# get effects object:
groupEffects <- getEffects(groupdata)

# etc. (the rest follows the same pattern as 'normal' analyses).
# More specifically:

groupEffects <- includeEffects(groupEffects,transTrip,cycle3)
groupEffects <- includeEffects(groupEffects,X,interaction1="primary")
groupEffects <- includeEffects(groupEffects,egoX,altX,sameX,interaction1="sexM")

# include ego effects of dummy paramters to identify density differences between classes:
groupEffects <- includeEffects(groupEffects,egoX,interaction1="dummy03e")
groupEffects <- includeEffects(groupEffects,egoX,interaction1="dummy12b")

# also include interactions of dummies with sex segregation:
groupEffects <- includeInteraction(groupEffects,sameX,egoX,interaction1=c("sexM","dummy03e"))
groupEffects <- includeInteraction(groupEffects,sameX,egoX,interaction1=c("sexM","dummy12b"))

# again define model object:
groupModel <- sienaModelCreate(useStdInits=FALSE, projname='group')

# and run the analysis:
groupResults <- siena07(groupModel, data=groupdata, effects=groupEffects, batch=TRUE, verbose=FALSE)

# ---------------- STARTING META-ANALYSIS ------------------

klas03eeffects <- getEffects(klas03edata)
klas12beffects <- getEffects(klas12bdata)
klas12peffects <- getEffects(klas12pdata)

# specify same model for the three groups:
klas03eeffects <- includeEffects(klas03eeffects,transTrip,cycle3)
klas03eeffects <- includeEffects(klas03eeffects,X,interaction1="primary")
klas03eeffects <- includeEffects(klas03eeffects,egoX,altX,sameX,interaction1="sexM")
klas03eeffects <- includeEffects(klas03eeffects,simRecipX,interaction1="sexM")
klas03eeffects[klas03eeffects$shortName=='simRecipX'&
  klas03eeffects$type=='eval',c('fix','test')]<-TRUE

klas12beffects <- includeEffects(klas12beffects,transTrip,cycle3)
klas12beffects <- includeEffects(klas12beffects,X,interaction1="primary")
klas12beffects <- includeEffects(klas12beffects,egoX,altX,sameX,interaction1="sexM")
klas12beffects <- includeEffects(klas12beffects,simRecipX,interaction1="sexM")
klas12beffects[klas12beffects$shortName=='simRecipX'&
  klas12beffects$type=='eval',c('fix','test')]<-TRUE

klas12peffects <- includeEffects(klas12peffects,transTrip,cycle3)
klas12peffects <- includeEffects(klas12peffects,X,interaction1="primary")
klas12peffects <- includeEffects(klas12peffects,egoX,altX,sameX,interaction1="sexM")
klas12peffects <- includeEffects(klas12peffects,simRecipX,interaction1="sexM")
klas12peffects[klas12peffects$shortName=='simRecipX'&
  klas12peffects$type=='eval',c('fix','test')]<-TRUE

klas12bmodel <- sienaModelCreate(useStdInits=FALSE, projname='klas12b')
klas12pmodel <- sienaModelCreate(useStdInits=FALSE, projname='klas12p')
klas03emodel <- sienaModelCreate(useStdInits=FALSE, projname='klas03e')

klas03eresults <- siena07(klas03emodel, data=klas03edata, effects=klas03eeffects, batch=TRUE, verbose=FALSE)
klas12bresults <- siena07(klas12bmodel, data=klas12bdata, effects=klas12beffects, batch=TRUE, verbose=FALSE)
klas12presults <- siena07(klas12pmodel, data=klas12pdata, effects=klas12peffects, batch=TRUE, verbose=FALSE)

# perform meta-analysis:
metaresults <- siena08(klas03eresults,klas12bresults,klas12presults)

